<?php
require_once("../includes/db.php");
require_once("../includes/dompdf/autoload.inc.php");
use Dompdf\Dompdf;

$dompdf = new Dompdf();
$html = "<h2>Penyata Pendapatan & Perbelanjaan</h2>";

$pendapatan = $conn->query("SELECT kod_akaun, SUM(amaun) AS jumlah FROM transactions 
                            WHERE kod_akaun IN (SELECT kod_akaun FROM chart_of_accounts WHERE kategori='Pendapatan')
                            GROUP BY kod_akaun");
$perbelanjaan = $conn->query("SELECT kod_akaun, SUM(amaun) AS jumlah FROM transactions 
                              WHERE kod_akaun IN (SELECT kod_akaun FROM chart_of_accounts WHERE kategori='Perbelanjaan')
                              GROUP BY kod_akaun");

$html .= "<h3>Pendapatan</h3><ul>";
$total_pendapatan = 0;
while ($row = $pendapatan->fetch_assoc()) {
    $html .= "<li>{$row['kod_akaun']}: RM " . number_format($row['jumlah'], 2) . "</li>";
    $total_pendapatan += $row['jumlah'];
}
$html .= "</ul><strong>Jumlah Pendapatan: RM " . number_format($total_pendapatan, 2) . "</strong>";

$html .= "<h3>Perbelanjaan</h3><ul>";
$total_perbelanjaan = 0;
while ($row = $perbelanjaan->fetch_assoc()) {
    $html .= "<li>{$row['kod_akaun']}: RM " . number_format(abs($row['jumlah']), 2) . "</li>";
    $total_perbelanjaan += abs($row['jumlah']);
}
$html .= "</ul><strong>Jumlah Perbelanjaan: RM " . number_format($total_perbelanjaan, 2) . "</strong>";

$lebihan = $total_pendapatan - $total_perbelanjaan;
$html .= "<h3 style='margin-top:20px;'>Lebihan / (Defisit): RM " . number_format($lebihan, 2) . "</h3>";

$dompdf->loadHtml($html);
$dompdf->setPaper("A4", "portrait");
$dompdf->render();
$dompdf->stream("penyata_pendapatan_perbelanjaan.pdf", ["Attachment" => false]);
exit;
?>
