
CREATE DATABASE IF NOT EXISTS akaun_ngo;
USE akaun_ngo;

CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama VARCHAR(100),
    email VARCHAR(100),
    kata_laluan VARCHAR(255),
    peranan ENUM('admin', 'bendahari') DEFAULT 'bendahari'
);

CREATE TABLE chart_of_accounts (
    id INT AUTO_INCREMENT PRIMARY KEY,
    kod_akaun VARCHAR(10),
    nama_akaun VARCHAR(100),
    kategori ENUM('Aset', 'Liabiliti', 'Ekuiti', 'Pendapatan', 'Perbelanjaan')
);

CREATE TABLE transactions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tarikh DATE,
    butiran TEXT,
    kod_akaun VARCHAR(10),
    amaun DECIMAL(10,2),
    kaedah_bayaran ENUM('Tunai', 'Bank'),
    lampiran VARCHAR(255),
    dibuat_oleh INT,
    FOREIGN KEY (dibuat_oleh) REFERENCES users(id)
);
