self.addEventListener("install", function(event) {
  event.waitUntil(
    caches.open("ngo-cache").then(function(cache) {
      return cache.addAll([
        "/",
        "/index.php",
        "/assets/css/style.css",
        "/assets/js/script.js"
      ]);
    })
  );
});

self.addEventListener("fetch", function(event) {
  event.respondWith(
    caches.match(event.request).then(function(response) {
      return response || fetch(event.request);
    })
  );
});
