<?php
require_once("includes/db.php");
require_once("includes/dompdf/autoload.inc.php");
use Dompdf\Dompdf;

$bulan = isset($_GET['bulan']) ? intval($_GET['bulan']) : date('n');
$tahun = isset($_GET['tahun']) ? intval($_GET['tahun']) : date('Y');

$pendapatan_q = $conn->query("SELECT SUM(amaun) AS jumlah FROM transactions 
    WHERE MONTH(tarikh) = $bulan AND YEAR(tarikh) = $tahun 
    AND kod_akaun IN (SELECT kod_akaun FROM chart_of_accounts WHERE kategori='Pendapatan')");
$perbelanjaan_q = $conn->query("SELECT SUM(amaun) AS jumlah FROM transactions 
    WHERE MONTH(tarikh) = $bulan AND YEAR(tarikh) = $tahun 
    AND kod_akaun IN (SELECT kod_akaun FROM chart_of_accounts WHERE kategori='Perbelanjaan')");

$pendapatan = $pendapatan_q->fetch_assoc()['jumlah'] ?? 0;
$perbelanjaan = abs($perbelanjaan_q->fetch_assoc()['jumlah'] ?? 0);
$lebihan = $pendapatan - $perbelanjaan;

$bulanLabel = date("F", mktime(0, 0, 0, $bulan, 10));

$html = "<h2 style='text-align:center;'>Laporan Statistik Bulanan</h2>
<h3 style='text-align:center;'>$bulanLabel $tahun</h3>
<table width='60%' align='center' border='1' cellpadding='10' cellspacing='0' style='border-collapse:collapse;'>
  <tr><td><strong>Pendapatan</strong></td><td>RM " . number_format($pendapatan, 2) . "</td></tr>
  <tr><td><strong>Perbelanjaan</strong></td><td>RM " . number_format($perbelanjaan, 2) . "</td></tr>
  <tr><td><strong>Lebihan / Defisit</strong></td><td>RM " . number_format($lebihan, 2) . "</td></tr>
</table>";

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper("A4", "portrait");
$dompdf->render();
$dompdf->stream("Statistik_{$bulanLabel}_{$tahun}.pdf", ["Attachment" => false]);
exit;
?>
