<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'includes/PHPMailer/src/Exception.php';
require 'includes/PHPMailer/src/PHPMailer.php';
require 'includes/PHPMailer/src/SMTP.php';

require_once("includes/db.php");
require_once("includes/dompdf/autoload.inc.php");
use Dompdf\Dompdf;

// Tetapan emel
$bulan = date('n');
$tahun = date('Y');
$bulanLabel = date("F", mktime(0, 0, 0, $bulan, 10));
$pendapatan_q = $conn->query("SELECT SUM(amaun) AS jumlah FROM transactions 
    WHERE MONTH(tarikh) = $bulan AND YEAR(tarikh) = $tahun 
    AND kod_akaun IN (SELECT kod_akaun FROM chart_of_accounts WHERE kategori='Pendapatan')");
$perbelanjaan_q = $conn->query("SELECT SUM(amaun) AS jumlah FROM transactions 
    WHERE MONTH(tarikh) = $bulan AND YEAR(tarikh) = $tahun 
    AND kod_akaun IN (SELECT kod_akaun FROM chart_of_accounts WHERE kategori='Perbelanjaan')");

$pendapatan = $pendapatan_q->fetch_assoc()['jumlah'] ?? 0;
$perbelanjaan = abs($perbelanjaan_q->fetch_assoc()['jumlah'] ?? 0);
$lebihan = $pendapatan - $perbelanjaan;

// Jana PDF
$html = "<h2 style='text-align:center;'>Laporan Statistik Bulanan</h2>
<h3 style='text-align:center;'>$bulanLabel $tahun</h3>
<table width='60%' align='center' border='1' cellpadding='10' cellspacing='0' style='border-collapse:collapse;'>
  <tr><td><strong>Pendapatan</strong></td><td>RM " . number_format($pendapatan, 2) . "</td></tr>
  <tr><td><strong>Perbelanjaan</strong></td><td>RM " . number_format($perbelanjaan, 2) . "</td></tr>
  <tr><td><strong>Lebihan / Defisit</strong></td><td>RM " . number_format($lebihan, 2) . "</td></tr>
</table>";

$dompdf = new Dompdf();
$dompdf->loadHtml($html);
$dompdf->setPaper("A4", "portrait");
$dompdf->render();
$pdf_output = $dompdf->output();
$pdf_path = "laporan_bulanan_{$bulan}_{$tahun}.pdf";
file_put_contents($pdf_path, $pdf_output);

// Konfigurasi emel
$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host       = 'smtp.example.com'; // Ganti dengan SMTP sebenar
    $mail->SMTPAuth   = true;
    $mail->Username   = 'you@example.com';  // Emel penghantar
    $mail->Password   = 'yourpassword';     // Kata laluan
    $mail->SMTPSecure = 'tls';
    $mail->Port       = 587;

    $mail->setFrom('you@example.com', 'Sistem Akaun NGO');
    $mail->addAddress('bendahari@example.com', 'Bendahari NGO'); // Penerima

    $mail->addAttachment($pdf_path);
    $mail->isHTML(true);
    $mail->Subject = "Laporan Bulanan NGO - $bulanLabel $tahun";
    $mail->Body    = "Dilampirkan laporan kewangan bulan <strong>$bulanLabel $tahun</strong> dalam format PDF.";

    $mail->send();
    echo "Laporan berjaya dihantar ke emel bendahari.";
} catch (Exception $e) {
    echo "Emel tidak berjaya dihantar. Ralat: {$mail->ErrorInfo}";
}
?>
